/*
 * Decompiled with CFR 0.152.
 */
package gloridifice.watersource.common.network;

import gloridifice.watersource.common.capability.WaterLevelCapability;
import gloridifice.watersource.common.network.INormalMessage;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class PlayerWaterLevelMessage
implements INormalMessage {
    int waterLevel;
    int waterSaturationLevel;
    float waterExhaustionLevel;

    public PlayerWaterLevelMessage(int waterLevel, int waterSaturationLevel, float waterExhaustionLevel) {
        this.waterLevel = waterLevel;
        this.waterSaturationLevel = waterSaturationLevel;
        this.waterExhaustionLevel = waterExhaustionLevel;
    }

    public PlayerWaterLevelMessage(PacketBuffer buf) {
        this.waterLevel = buf.readInt();
        this.waterSaturationLevel = buf.readInt();
        this.waterExhaustionLevel = buf.readFloat();
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.waterLevel);
        buf.writeInt(this.waterSaturationLevel);
        buf.writeFloat(this.waterExhaustionLevel);
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        if (context.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            context.get().enqueueWork(() -> Minecraft.func_71410_x().field_71439_g.getCapability(WaterLevelCapability.PLAYER_WATER_LEVEL).ifPresent(date -> {
                date.setWaterSaturationLevel(this.waterSaturationLevel);
                date.setWaterLevel(this.waterLevel);
                date.setWaterExhaustionLevel(this.waterExhaustionLevel);
            }));
        }
    }
}

